﻿Scriptname _JSW_G_ConfigScript extends SKI_ConfigBase  

Actor Property PlayerRef  Auto

_JSW_G_HandlerQuestAliasScript Property Handler  Auto

GlobalVariable Property MasteryDelta  Auto
GlobalVariable Property SkillDelta  Auto
GlobalVariable Property ConsumeTomes  Auto

int function GetVersion()
	return 1
endFunction

event OnVersionUpdate(int version)
	if (version == 1)
		Pages = new String[1]
		Pages[0] = "Settings"
	endIf
endEvent

event OnPageReset(string page)
	if (page == "Settings")
		ResetPageSettings()
	endIf
endEvent

function ResetPageSettings()
	SetCursorFillMode(TOP_TO_BOTTOM)
	
	AddHeaderOption("Settings")
	AddSliderOptionST("MASTERY_DELTA_SLIDER", "Base Mastery Growth", MasteryDelta.GetValue(), "{4}")
	AddSliderOptionST("SKILL_DELTA_SLIDER", "Skill Bonus", SkillDelta.GetValue(), "{4}")
	AddToggleOptionST("CONSUME_TOMES_TOGGLE", "Consume Tomes", ConsumeTomes.GetValueInt())
	
	SetCursorPosition(1)
	
	Spell leftHand = PlayerRef.GetEquippedSpell(0)
	Spell rightHand = PlayerRef.GetEquippedSpell(1)
	
	AddHeaderOption("Current Spell(s)")
	
	if (leftHand)
		int index = Handler.Spells.Find(leftHand)
		
		AddTextOption("Left Hand: " + leftHand.GetName(), "")
		
		if (index != -1)
			AddTextOption("\tSkill: " + Handler.Skill[index], "")
			AddTextOption("\tLevel: " + Handler.Level[index], "")
			AddTextOption("\tMastery: " + Handler.Mastery[index], "")
			AddTextOption("\tTomes: " + PlayerRef.GetItemCount(Handler.SpellTomes[index]), "")
		else
			AddTextOption("\tUnrecognized spell", "")
		endIf
	else
		AddTextOption("Left Hand: No spell equipped", "")
	endIf
	
	if (rightHand)
		int index = Handler.Spells.Find(rightHand)
		
		AddTextOption("Right Hand: " + rightHand.GetName(), "")
		
		if (index != -1)
			AddTextOption("\tSkill: " + Handler.Skill[index], "")
			AddTextOption("\tLevel: " + Handler.Level[index], "")
			AddTextOption("\tMastery: " + Handler.Mastery[index], "")
			AddTextOption("\tTomes: " + PlayerRef.GetItemCount(Handler.SpellTomes[index]), "")
		else
			AddTextOption("\tUnrecognized spell", "")
		endIf
	else
		AddTextOption("Right Hand: No spell equipped", "")
	endIf
endFunction

state MASTERY_DELTA_SLIDER
	event OnSliderOpenST()
		SetSliderDialogStartValue(MasteryDelta.GetValue())
		SetSliderDialogRange(0.0001, 1.0)
		SetSliderDialogInterval(0.0001)
	endEvent

	event OnSliderAcceptST(float value)
		MasteryDelta.SetValue(value)
		SetSliderOptionValueST(value, "{4}")
	endEvent

	event OnHighlightST()
		SetInfoText("Specifies the amount of mastery growth per spell cast\nWhen mastery reaches 1.0, the spell has been fully mastered")
	endEvent
endState

state SKILL_DELTA_SLIDER
	event OnSliderOpenST()
		SetSliderDialogStartValue(SkillDelta.GetValue())
		SetSliderDialogRange(0.0001, 1.0)
		SetSliderDialogInterval(0.0001)
	endEvent

	event OnSliderAcceptST(float value)
		SkillDelta.SetValue(value)
		SetSliderOptionValueST(value, "{4}")
	endEvent

	event OnHighlightST()
		SetInfoText("Specifies a mastery bonus when overskilled for the spell\nThe bonus is multiplied by the number of levels the player is overskilled")
	endEvent
endState

state CONSUME_TOMES_TOGGLE
	event OnSelectST()
		if (ConsumeTomes.GetValueInt())
			ConsumeTomes.SetValueInt(0)
		else
			ConsumeTomes.SetValueInt(1)
		endIf
		
		SetToggleOptionValueST(ConsumeTomes.GetValueInt())
	endEvent

	event OnDefaultST()
		SetToggleOptionValueST(ConsumeTomes.GetValueInt())
	endEvent

	event OnHighlightST()
		SetInfoText("Enables or disables the default behavior of consuming a spell tome when first read")
	endEvent
endState